/*
Exercice 4
crire un programme qui,  laide dune pile, value lexpression arithmtique postfixe :
5 11 9 + 2 12 * - 8 / * .
Puis  laide dune autre pile, transformer lexpression postfixe en son expression infixe 
(oprateur entre 2 oprandes le tout entre parenthses).
*/

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <ctype.h>
#include <string.h>


void Menu();
float Evaluer(char* expPostfixee);
char* Traduire(char* expPostfixee);

int main()
{
	int fin = 0;
	char Post[] = "5 11 9 + 2 12 * - 8 / *";

	Menu();
	while (fin != 'q') {

		switch (_getch()) {
		case 'a':
			printf("Evaluation de : %s\n", Post);
			printf("res : %.2f\n", Evaluer(Post));
			break;
		case 'z':
		{
			printf("Traduction de : %s\n", Post);
			char* res = Traduire(Post);
			printf("res : %s\n", res);
			free(res);
		}
			break;
		case 'q':
			fin = 'q';
			break;
		}

	}
	return 0;
}
void Menu()
{
	printf("a : Evaluation expression post fixee\n");
	printf("z : Traduction post fixe en infixe\n");
}

/*Attention :
les fonctions Evaluer et Traduire ne sont pas scurises. 
Elles supposent chacune une expression correcte  en entre. Pour 
scuriser les fonctions il faut essentiellement vrifier le bon  
fonctionnement de chaque pile (sommet doit toujours tre compris 
entre 0 et max-1). Le mieux dans cette perspective est de traiter 
le fonctionnement de la pile  part, hors des fonctions. 

Il s'agit ici de montrer le caractre trs simple finalement d'une pile
et la possibilit rapide d'en implmenter une.
*/
float Evaluer(char* post)
{
	// la pile (un tableau)
	int max = strlen(post); // cette taille ne pourra jamais tre dpasse.
	float *p = (float*)malloc(sizeof(float)* max);
	int sommet = 0;

	// pour calculer
	float v1 = 0;
	float v2 = 0;
	float res = 0;;

	// action
	// pour commencer il faut rcuprer les nombres afin de recomposer ensuite les oprations.
	// Les nombres de l'expressions sont considrs comme des nombres entiers uniquement mais 
	// le rsultat de l'expression peut tre une valeur dcimales.

	// Nous ne pouvons pas utiliser sscanf(.., "%d",&val) parce que un oprateur est aussi un 
	// nombre par exemple '+' vaut 43 dans la table acsii. L'utilisation %d pour '+' met 43  
	// dans val et nous ne pouvons pas ensuite diffrencier 43 le nombre de 43 l'oprateur en 
	// ascii.
	for (int i = 0; post[i] != '\0'; i++) {
		if (isdigit(post[i])) { // rcuprer les nombres
			int n;
			for (n = 0; post[i] != ' '; i++) 
				n = n * 10 + (post[i] - '0');
			p[sommet++] = n;   // incrmentation aprs affectation de n
		}
		// si oprateur faire l'opration et empiler le rsultat
		else if(post[i] != ' '){
			// dcrmentation avant affectation. attention en cas 
			// d'erreur dans l'expression il est possible de passer 
			// en dessous de 0 et de provoquer une erreur  l'excution.
			v2 = p[--sommet]; 
			v1 = p[--sommet]; 
			switch (post[i]) {
				case '+': p[sommet++] = v1 + v2; break;
				case '-': p[sommet++] = v1 - v2; break;
				case '*': p[sommet++] = v1 * v2; break;
				case '/': p[sommet++] = v1 / v2; break;
			}
		}
	}
	// Si l'expression est correcte au dpart  la fin 
	// ne reste que le rsulat dans la pile
	res = p[--sommet];
	free(p);
	return res;
}

char* Traduire(char* expPostFixee)
{
	// faire une copie de l'expression passe avant sa dcoupe
	int max = strlen(expPostFixee) + 1;
	char* post = (char*)malloc(sizeof(char) * max );
	strcpy_s(post, max, expPostFixee);

	// tableau de char*, taille maximum sur nombre de caractres de l'expression
	char** p = (char**)malloc(sizeof(char*) * strlen(post));
	int sommet = 0;
	char *res = NULL;

	/* La fonction strtok :
	Recherche les mots de la chaine param1 (p1) en prenant comme ensemble 
	de sparateurs les caractres de la chaine param2 (p2). Lors du premier 
	appel la fonction modifie la chaine p1 en dplacant le caractre '\0'
	 la fin du premier mot, et retourne l'adresse de ce mot. Les appels 
	suivants doivent tre effectus avec NULL comme premier paramtre, la
	fonction concervant la position courante dans la chaine entre deux appels. 
	Cette position courante est stocke  chaque appel dans le param3 (p3). 
	Lorsqu'il n'y a plus de mot la fonction retourne NULL et p3 vaut NULL.*/

	char* next = NULL;
	char* e = NULL;

	// empiler le premier lment de la chaine post.
	e = strtok_s(post, " ",&next);
	p[sommet++] = e;
 
	do {
		e = strtok_s(NULL, " ", &next);
		if (e != NULL) {

			// si nombre empiler
			if (isdigit(e[0]))
				p[sommet++] = e;

			// si oprateur constituer la chaine en infix
			else { 
				char* v1, * v2;
				char exp[100] = { 0 };

				v2 = p[--sommet];
				v1 = p[--sommet];

				strcat_s(exp, 100, "(");
				strcat_s(exp, 100, v1);
				strcat_s(exp, 100, e);
				strcat_s(exp, 100, v2);			
				strcat_s(exp, 100, ")");

				res = malloc(sizeof(char) * (strlen(exp) + 1));
				strcpy_s(res, strlen(exp) + 1, exp);
				p[sommet++] = res;
				printf("%s\n", res);
			}
		}
	} while (e != NULL);
	// en principe  la fin le rsultat se trouve dans res, au sommet de la pile
	free(p);
	free(post);
	return res;
}